<?php
/**
 * CourierBee Advanced License System
 * Protects against cracks, domain theft & spoofing
 */

define("LICENSE_SERVER", "https://secure.courierbee.in/license-server/verify.php");
define("CACHE_FILE", __DIR__."/license.cache");
define("GRACE_DAYS", 3); // Allow offline for 3 days

$key = trim(@file_get_contents(__DIR__."/license.key"));
$domain = strtolower($_SERVER['HTTP_HOST']);
$ip = $_SERVER['SERVER_ADDR'] ?? '';
$fingerprint = hash("sha256", php_uname().$domain.$ip);

if(!$key){
    licenseFail("Missing License Key");
}

/* --- Try server validation --- */
$url = LICENSE_SERVER."?key=".urlencode($key)."&domain=".urlencode($domain)."&fp=".$fingerprint;
$resp = @file_get_contents($url);
$data = json_decode($resp,true);

/* --- If server reachable --- */
if(is_array($data) && isset($data['status'])){
    if($data['status']==="active"){
        file_put_contents(CACHE_FILE, json_encode([
            "time"=>time(),
            "fp"=>$fingerprint
        ]));
        return; // allow
    }
    licenseFail("License Blocked");
}

/* --- Server offline? use cache --- */
if(file_exists(CACHE_FILE)){
    $cache = json_decode(file_get_contents(CACHE_FILE), true);
    if($cache && $cache['fp']===$fingerprint){
        $days = (time() - $cache['time']) / 86400;
        if($days <= GRACE_DAYS){
            return; // temporary allow
        }
    }
}

/* --- Hard fail --- */
licenseFail("License Server Unreachable");


function licenseFail($reason){
    http_response_code(403);
    echo "
    <style>
        body{margin:0;background:#020617;font-family:Inter,system-ui;color:#fff;
        display:flex;align-items:center;justify-content:center;height:100vh}
        .box{background:#0f172a;padding:40px;border-radius:12px;max-width:500px;text-align:center;
        box-shadow:0 0 50px rgba(0,0,0,.8)}
        h1{color:#ef4444;margin-bottom:10px}
        p{color:#94a3b8;font-size:15px}
        .key{margin-top:20px;padding:12px;background:#020617;border-radius:6px;color:#38bdf8;font-family:monospace}
        .btn{margin-top:20px;display:inline-block;padding:12px 20px;background:#2563eb;color:white;
        border-radius:6px;text-decoration:none;font-weight:700}
    </style>

    <div class='box'>
        <h1>🚫 CourierBee License Error</h1>
        <p>$reason</p>
        <p>This domain is not authorized to run this software.</p>
        <div class='key'>".htmlspecialchars($_SERVER['HTTP_HOST'])."</div>
        <a class='btn' href='mailto:support@courierbee.in'>Contact Support</a>
    </div>";
    exit;
}