<?php
session_start();
require "../config.php";

if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}

// Logic to handle actions (Block/Unblock/Delete)
if (isset($_GET['action']) && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    if ($_GET['action'] === 'block') $pdo->prepare("UPDATE licenses SET status='blocked' WHERE id=?")->execute([$id]);
    if ($_GET['action'] === 'unblock') $pdo->prepare("UPDATE licenses SET status='active' WHERE id=?")->execute([$id]);
    if ($_GET['action'] === 'delete') $pdo->prepare("DELETE FROM licenses WHERE id=?")->execute([$id]);
    header("Location: dashboard.php");
    exit;
}

// Dynamic Data Fetching
$total_issued = $pdo->query("SELECT count(*) FROM licenses")->fetchColumn();
$active_count = $pdo->query("SELECT count(*) FROM licenses WHERE status='active'")->fetchColumn();
$licenses = $pdo->query("SELECT * FROM licenses ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>CourierBee Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary: #2563eb;
            --bg: #fdfdff;
            --card-bg: #ffffff;
            --text-dark: #1e293b;
            --text-light: #64748b;
            --success: #dcfce7;
            --success-text: #166534;
        }

        body {
            margin: 0; padding: 0; font-family: 'Inter', sans-serif;
            background-color: var(--bg); color: var(--text-dark);
            display: flex; flex-direction: column; min-height: 100vh;
        }

        /* Top Header */
        .header {
            padding: 15px 20px; display: flex; justify-content: space-between; align-items: center;
            background: #fff; position: sticky; top: 0; z-index: 10;
        }
        .header .logo { color: var(--primary); font-weight: 800; font-size: 22px; }
        .header .add-btn { color: var(--primary); font-size: 24px; text-decoration: none; }

        .container { padding: 0 20px 100px 20px; max-width: 600px; margin: 0 auto; width: 100%; box-sizing: border-box; }

        h1 { font-size: 28px; font-weight: 800; margin: 10px 0 20px 0; }

        /* Search Bar */
        .search-box {
            background: #fff; border: 1px solid #e2e8f0; border-radius: 12px;
            padding: 12px 15px; display: flex; align-items: center; gap: 10px; margin-bottom: 25px;
        }
        .search-box i { color: var(--text-light); }
        .search-box input { border: none; outline: none; width: 100%; font-size: 16px; color: var(--text-dark); }

        /* Stats Cards */
        .stat-card {
            background: #fff; border-radius: 20px; padding: 20px; margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.03); border: 1px solid #f1f5f9;
        }
        .stat-card.active-border { border-left: 5px solid #10b981; }
        .stat-label { color: var(--text-light); font-size: 11px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px; }
        .stat-value { font-size: 32px; font-weight: 800; display: block; margin-top: 5px; }

        /* License Card */
        .license-card {
            background: #fff; border-radius: 24px; padding: 25px; margin-bottom: 15px;
            border: 1px solid #f1f5f9; box-shadow: 0 4px 20px rgba(0,0,0,0.04);
        }
        .row { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 15px; }
        .label { color: var(--text-light); font-size: 12px; font-weight: 700; text-transform: uppercase; }
        
        .val-key { color: var(--primary); font-weight: 700; font-family: monospace; font-size: 14px; text-align: right; }
        .val-owner { font-weight: 700; color: var(--text-dark); text-align: right; word-break: break-all; }
        .val-domain { color: var(--text-light); font-size: 13px; margin-top: 2px; text-align: right; }

        .badge { 
            padding: 6px 16px; border-radius: 12px; font-weight: 800; font-size: 12px;
        }
        .badge.active { background: var(--success); color: var(--success-text); }
        .badge.blocked { background: #fee2e2; color: #b91c1c; }

        .footer-actions { 
            display: flex; justify-content: flex-end; gap: 20px; margin-top: 20px; 
            padding-top: 15px; border-top: 1px solid #f8fafc;
        }
        .footer-actions a { color: #64748b; font-size: 18px; text-decoration: none; transition: 0.2s; }
        .footer-actions a.del { color: #ef4444; }

        /* Bottom Nav */
        .bottom-nav {
            position: fixed; bottom: 0; width: 100%; background: #fff;
            display: flex; justify-content: space-around; padding: 12px 0;
            border-top: 1px solid #f1f5f9; box-shadow: 0 -5px 20px rgba(0,0,0,0.02);
        }
        .nav-item { text-align: center; text-decoration: none; color: #94a3b8; flex: 1; }
        .nav-item i { font-size: 22px; display: block; margin-bottom: 4px; }
        .nav-item span { font-size: 11px; font-weight: 600; }
        .nav-item.active { color: var(--primary); }
    </style>
</head>
<body>

    <div class="header">
        <div class="logo">CourierBee</div>
        <a href="generate.php" class="add-btn"><i class="fas fa-plus-circle"></i></a>
    </div>

    <div class="container">
        <h1>Licenses</h1>

        <div class="search-box">
            <i class="fas fa-search"></i>
            <input type="text" id="searchInput" placeholder="Search by key, domain...">
        </div>

        <div class="stat-card">
            <span class="stat-label">Total Issued</span>
            <span class="stat-value"><?= $total_issued ?></span>
        </div>

        <div class="stat-card active-border">
            <span class="stat-label">Active Licenses</span>
            <span class="stat-value"><?= $active_count ?></span>
        </div>

        <div id="licenseList">
            <?php foreach($licenses as $l): ?>
            <div class="license-card">
                <div class="row">
                    <span class="label">Key</span>
                    <span class="val-key"><?= htmlspecialchars($l['license_key']) ?></span>
                </div>
                <div class="row">
                    <span class="label">Owner</span>
                    <div style="flex:1">
                        <div class="val-owner"><?= htmlspecialchars($l['owner_email']) ?></div>
                        <div class="val-domain"><?= $l['domain'] ?: "No Domain Attached" ?></div>
                    </div>
                </div>
                <div class="row">
                    <span class="label">Status</span>
                    <span class="badge <?= $l['status'] ?>"><?= strtoupper($l['status']) ?></span>
                </div>
                <div class="row">
                    <span class="label">Expiry</span>
                    <span style="font-weight: 600; font-size: 14px;"><?= $l['expires_at'] ?: "Lifetime" ?></span>
                </div>

                <div class="footer-actions">
                    <?php if($l['status'] == 'active'): ?>
                        <a href="?action=block&id=<?= $l['id'] ?>"><i class="fas fa-lock"></i></a>
                    <?php else: ?>
                        <a href="?action=unblock&id=<?= $l['id'] ?>" style="color: #10b981;"><i class="fas fa-lock-open"></i></a>
                    <?php endif; ?>
                    <a href="?action=delete&id=<?= $l['id'] ?>" class="del" onclick="return confirm('Delete this license?')"><i class="fas fa-trash"></i></a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item active">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="generate.php" class="nav-item">
            <i class="fas fa-plus-square"></i>
            <span>Create</span>
        </a>
        <a href="#" class="nav-item">
            <i class="fas fa-search"></i>
            <span>Search</span>
        </a>
        <a href="settings.php" class="nav-item">
            <i class="fas fa-user-cog"></i>
            <span>Profile</span>
        </a>
    </div>

    <script>
        // Real-time Dynamic Search Logic
        document.getElementById('searchInput').addEventListener('keyup', function() {
            let filter = this.value.toLowerCase();
            let cards = document.querySelectorAll('.license-card');
            
            cards.forEach(card => {
                let text = card.innerText.toLowerCase();
                card.style.display = text.includes(filter) ? 'block' : 'none';
            });
        });
    </script>
</body>
</html>
