<?php
session_start();
require "../config.php";

if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}

$message = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $license_key = "CB-" . strtoupper(bin2hex(random_bytes(8))); // Unique Key Generation
    $owner_email = $_POST['email'];
    $duration = $_POST['duration']; // in days
    
    $expires_at = ($duration == 'lifetime') ? null : date('Y-m-d', strtotime("+$duration days"));

    $stmt = $pdo->prepare("INSERT INTO licenses (license_key, owner_email, expires_at, status) VALUES (?, ?, ?, 'active')");
    if ($stmt->execute([$license_key, $owner_email, $expires_at])) {
        $message = "success";
    } else {
        $message = "error";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Create License | CourierBee</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary: #2563eb;
            --bg: #fdfdff;
            --card-bg: #ffffff;
            --text-dark: #1e293b;
            --text-light: #64748b;
            --input-bg: #f8fafc;
        }

        body {
            margin: 0; padding: 0; font-family: 'Inter', sans-serif;
            background-color: var(--bg); color: var(--text-dark);
            display: flex; flex-direction: column; min-height: 100vh;
        }

        /* Top Header */
        .header {
            padding: 15px 20px; display: flex; align-items: center; gap: 15px;
            background: #fff; position: sticky; top: 0; z-index: 10;
        }
        .header a { color: var(--text-dark); text-decoration: none; font-size: 20px; }
        .header .title { font-weight: 800; font-size: 20px; color: var(--primary); }

        .container { padding: 20px; max-width: 500px; margin: 0 auto; width: 100%; box-sizing: border-box; }

        .form-card {
            background: #fff; border-radius: 24px; padding: 30px;
            border: 1px solid #f1f5f9; box-shadow: 0 10px 30px rgba(0,0,0,0.04);
            margin-top: 10px;
        }

        .instruction { color: var(--text-light); font-size: 14px; margin-bottom: 25px; line-height: 1.5; }

        .input-group { margin-bottom: 20px; }
        .input-group label { display: block; font-size: 12px; font-weight: 700; text-transform: uppercase; color: var(--text-light); margin-bottom: 8px; margin-left: 5px; }
        
        .input-group input, .input-group select {
            width: 100%; padding: 14px 18px; border-radius: 16px; border: 1px solid #e2e8f0;
            background: var(--input-bg); font-size: 16px; font-family: inherit; outline: none;
            transition: 0.3s; box-sizing: border-box;
        }
        .input-group input:focus { border-color: var(--primary); background: #fff; box-shadow: 0 0 0 4px rgba(37, 99, 235, 0.1); }

        .submit-btn {
            width: 100%; padding: 16px; border-radius: 16px; border: none;
            background: var(--primary); color: #fff; font-size: 16px; font-weight: 700;
            cursor: pointer; margin-top: 10px; transition: 0.3s;
        }
        .submit-btn:active { transform: scale(0.98); }

        /* Success Message Overlay */
        .alert {
            padding: 15px; border-radius: 16px; margin-bottom: 20px; text-align: center; font-weight: 600;
        }
        .alert-success { background: #dcfce7; color: #166534; border: 1px solid #bbf7d0; }
        .alert-error { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }

        /* Bottom Nav (Same as Dashboard) */
        .bottom-nav {
            position: fixed; bottom: 0; width: 100%; background: #fff;
            display: flex; justify-content: space-around; padding: 12px 0;
            border-top: 1px solid #f1f5f9; box-shadow: 0 -5px 20px rgba(0,0,0,0.02);
        }
        .nav-item { text-align: center; text-decoration: none; color: #94a3b8; flex: 1; }
        .nav-item i { font-size: 22px; display: block; margin-bottom: 4px; }
        .nav-item span { font-size: 11px; font-weight: 600; }
        .nav-item.active { color: var(--primary); }
    </style>
</head>
<body>

    <div class="header">
        <a href="dashboard.php"><i class="fas fa-arrow-left"></i></a>
        <div class="title">Create New License</div>
    </div>

    <div class="container">
        <?php if($message == "success"): ?>
            <div class="alert alert-success">✅ License Generated Successfully!</div>
        <?php elseif($message == "error"): ?>
            <div class="alert alert-error">❌ Error generating license.</div>
        <?php endif; ?>

        <div class="form-card">
            <p class="instruction">Fill in the details below to issue a new software license key for your customer.</p>
            
            <form action="" method="POST">
                <div class="input-group">
                    <label>Owner Email Address</label>
                    <input type="email" name="email" placeholder="customer@example.com" required>
                </div>

                <div class="input-group">
                    <label>License Duration</label>
                    <select name="duration" required>
                        <option value="30">1 Month (30 Days)</option>
                        <option value="90">3 Months</option>
                        <option value="365">1 Year</option>
                        <option value="lifetime">Lifetime Access</option>
                    </select>
                </div>

                <button type="submit" class="submit-btn">Generate Key</button>
            </form>
        </div>
    </div>

    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="generate.php" class="nav-item active">
            <i class="fas fa-plus-square"></i>
            <span>Create</span>
        </a>
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-search"></i>
            <span>Search</span>
        </a>
        <a href="#" class="nav-item">
            <i class="fas fa-user-cog"></i>
            <span>Profile</span>
        </a>
    </div>

</body>
</html>
