<?php
session_start();
require "../config.php";

$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $user = trim($_POST['user'] ?? '');
    $pass = $_POST['pass'] ?? '';

    $stmt = $pdo->prepare("SELECT * FROM license_admins WHERE username=? LIMIT 1");
    $stmt->execute([$user]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($admin && password_verify($pass, $admin['password'])) {
        session_regenerate_id(true); 
        $_SESSION['admin_id'] = $admin['id'];

        $pdo->prepare("UPDATE license_admins SET last_login=NOW() WHERE id=?")
            ->execute([$admin['id']]);

        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Invalid username or password";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Login | CourierBee Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary: #2563eb;
            --bg: #f8fafc;
            --text-dark: #1e293b;
            --text-light: #64748b;
        }

        * { box-sizing: border-box; }

        body {
            margin: 0; padding: 0; font-family: 'Inter', sans-serif;
            background-color: var(--bg);
            height: 100vh; display: flex; align-items: center; justify-content: center;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        }

        .login-container {
            width: 100%; max-width: 400px; padding: 20px;
        }

        .login-card {
            background: #ffffff; padding: 40px 30px; border-radius: 32px;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            text-align: center;
        }

        .logo-area {
            margin-bottom: 30px;
        }

        .logo-area i {
            font-size: 40px; color: var(--primary); margin-bottom: 10px;
        }

        .logo-area h2 {
            margin: 0; font-weight: 800; font-size: 24px; color: var(--text-dark);
            letter-spacing: -0.5px;
        }

        .logo-area p {
            color: var(--text-light); font-size: 14px; margin-top: 5px;
        }

        .input-group {
            margin-bottom: 20px; text-align: left;
        }

        .input-group label {
            display: block; font-size: 12px; font-weight: 700; color: var(--text-light);
            margin-bottom: 8px; margin-left: 5px; text-transform: uppercase;
        }

        .input-wrapper {
            position: relative;
        }

        .input-wrapper i {
            position: absolute; left: 18px; top: 50%; transform: translateY(-50%);
            color: #94a3b8; font-size: 18px;
        }

        .input-wrapper input {
            width: 100%; padding: 15px 15px 15px 50px; border-radius: 18px;
            border: 1px solid #e2e8f0; background: #f1f5f9; font-size: 16px;
            outline: none; transition: 0.3s; font-family: inherit;
        }

        .input-wrapper input:focus {
            border-color: var(--primary); background: #fff;
            box-shadow: 0 0 0 4px rgba(37, 99, 235, 0.1);
        }

        .error-msg {
            background: #fee2e2; color: #b91c1c; padding: 12px; border-radius: 14px;
            font-size: 13px; font-weight: 600; margin-bottom: 20px;
            display: flex; align-items: center; justify-content: center; gap: 8px;
        }

        .login-btn {
            width: 100%; padding: 16px; border-radius: 18px; border: none;
            background: var(--primary); color: #fff; font-size: 16px; font-weight: 700;
            cursor: pointer; transition: 0.3s; margin-top: 10px;
            box-shadow: 0 10px 15px -3px rgba(37, 99, 235, 0.3);
        }

        .login-btn:active {
            transform: scale(0.97);
        }

        .footer-text {
            margin-top: 25px; color: var(--text-light); font-size: 13px;
        }
    </style>
</head>
<body>

    <div class="login-container">
        <div class="login-card">
            <div class="logo-area">
                <i class="fas fa-shield-halved"></i>
                <h2>CourierBee Admin</h2>
                <p>Sign in to manage your licenses</p>
            </div>

            <?php if($error): ?>
                <div class="error-msg">
                    <i class="fas fa-exclamation-circle"></i> <?= $error ?>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="input-group">
                    <label>Username</label>
                    <div class="input-wrapper">
                        <i class="fas fa-user"></i>
                        <input name="user" type="text" placeholder="Enter username" required>
                    </div>
                </div>

                <div class="input-group">
                    <label>Password</label>
                    <div class="input-wrapper">
                        <i class="fas fa-lock"></i>
                        <input name="pass" type="password" placeholder="••••••••" required>
                    </div>
                </div>

                <button type="submit" class="login-btn">Secure Login</button>
            </form>

            <div class="footer-text">
                &copy; 2026 CourierBee Licensing System
            </div>
        </div>
    </div>

</body>
</html>
