<?php
session_start();
require "../config.php";

if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}

$admin_id = $_SESSION['admin_id'];
$message = "";

// Update Admin Details Logic
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $new_user = trim($_POST['username']);
    $new_pass = $_POST['password'];

    if (!empty($new_pass)) {
        // Update both username and password
        $hashed_pass = password_hash($new_pass, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE license_admins SET username = ?, password = ? WHERE id = ?");
        $stmt->execute([$new_user, $hashed_pass, $admin_id]);
    } else {
        // Update only username
        $stmt = $pdo->prepare("UPDATE license_admins SET username = ? WHERE id = ?");
        $stmt->execute([$new_user, $admin_id]);
    }
    $message = "Settings updated successfully!";
}

// Fetch current admin info
$stmt = $pdo->prepare("SELECT * FROM license_admins WHERE id = ?");
$stmt->execute([$admin_id]);
$admin = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Settings | CourierBee Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary: #2563eb;
            --bg: #fdfdff;
            --text-dark: #1e293b;
            --text-light: #64748b;
            --danger: #ef4444;
        }

        body {
            margin: 0; padding: 0; font-family: 'Inter', sans-serif;
            background-color: var(--bg); color: var(--text-dark);
        }

        .header {
            padding: 15px 20px; display: flex; align-items: center; gap: 15px;
            background: #fff; position: sticky; top: 0; z-index: 10;
        }
        .header .title { font-weight: 800; font-size: 20px; color: var(--primary); }

        .container { padding: 20px 20px 100px 20px; max-width: 500px; margin: 0 auto; }

        /* Profile Header */
        .profile-section {
            text-align: center; margin-bottom: 30px; padding: 20px;
        }
        .profile-icon {
            width: 80px; height: 80px; background: #eff6ff; color: var(--primary);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            font-size: 32px; margin: 0 auto 15px auto; border: 2px solid #dbeafe;
        }
        .profile-section h2 { margin: 0; font-size: 22px; font-weight: 800; }
        .profile-section p { color: var(--text-light); font-size: 14px; margin-top: 5px; }

        /* Form & Cards */
        .settings-card {
            background: #fff; border-radius: 24px; padding: 25px;
            border: 1px solid #f1f5f9; box-shadow: 0 4px 20px rgba(0,0,0,0.03);
            margin-bottom: 20px;
        }
        .settings-card h3 { font-size: 16px; margin-top: 0; margin-bottom: 20px; display: flex; align-items: center; gap: 10px; }

        .input-group { margin-bottom: 15px; }
        .input-group label { display: block; font-size: 11px; font-weight: 700; text-transform: uppercase; color: var(--text-light); margin-bottom: 8px; }
        .input-group input {
            width: 100%; padding: 14px; border-radius: 12px; border: 1px solid #e2e8f0;
            background: #f8fafc; font-size: 15px; outline: none; box-sizing: border-box;
        }

        .save-btn {
            width: 100%; padding: 15px; border-radius: 12px; border: none;
            background: var(--primary); color: #fff; font-weight: 700; cursor: pointer;
        }

        .logout-card {
            border: 1px solid #fee2e2; background: #fff;
        }
        .logout-btn {
            width: 100%; padding: 15px; display: flex; align-items: center; justify-content: center;
            gap: 10px; color: var(--danger); text-decoration: none; font-weight: 700;
        }

        /* Bottom Nav */
        .bottom-nav {
            position: fixed; bottom: 0; width: 100%; background: #fff;
            display: flex; justify-content: space-around; padding: 12px 0;
            border-top: 1px solid #f1f5f9; box-shadow: 0 -5px 20px rgba(0,0,0,0.02);
        }
        .nav-item { text-align: center; text-decoration: none; color: #94a3b8; flex: 1; }
        .nav-item i { font-size: 22px; display: block; margin-bottom: 4px; }
        .nav-item span { font-size: 11px; font-weight: 600; }
        .nav-item.active { color: var(--primary); }

        .alert { padding: 12px; border-radius: 12px; background: #dcfce7; color: #166534; font-size: 14px; text-align: center; margin-bottom: 20px; font-weight: 600; }
    </style>
</head>
<body>

    <div class="header">
        <div class="title">Settings</div>
    </div>

    <div class="container">
        <div class="profile-section">
            <div class="profile-icon"><i class="fas fa-user-shield"></i></div>
            <h2><?= htmlspecialchars($admin['username']) ?></h2>
            <p>Last login: <?= $admin['last_login'] ?: 'Never' ?></p>
        </div>

        <?php if($message): ?>
            <div class="alert"><?= $message ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="settings-card">
                <h3><i class="fas fa-user-edit"></i> Admin Credentials</h3>
                <div class="input-group">
                    <label>Username</label>
                    <input type="text" name="username" value="<?= htmlspecialchars($admin['username']) ?>" required>
                </div>
                <div class="input-group">
                    <label>New Password (Leave blank to keep current)</label>
                    <input type="password" name="password" placeholder="••••••••">
                </div>
                <button type="submit" class="save-btn">Update Profile</button>
            </div>
        </form>

        <div class="settings-card" style="padding: 10px;">
            <a href="login.php" class="logout-btn">
                <i class="fas fa-sign-out-alt"></i> Logout Session
            </a>
        </div>
        
        <div style="text-align: center; color: var(--text-light); font-size: 12px;">
            CourierBee License Engine v2.0.4
        </div>
    </div>

    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="generate.php" class="nav-item">
            <i class="fas fa-plus-square"></i>
            <span>Create</span>
        </a>
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-search"></i>
            <span>Search</span>
        </a>
        <a href="settings.php" class="nav-item active">
            <i class="fas fa-user-cog"></i>
            <span>Profile</span>
        </a>
    </div>

</body>
</html>
