<?php
require "config.php";

header("Content-Type: application/json");

$key    = trim($_GET['key'] ?? '');
$domain = strtolower(trim($_GET['domain'] ?? ''));
$fp     = trim($_GET['fp'] ?? ''); // fingerprint
$ip     = $_SERVER['REMOTE_ADDR'];

if(!$key || !$domain){
    deny("invalid");
}

/* Lookup license */
$stmt = $pdo->prepare("SELECT * FROM licenses WHERE license_key=? LIMIT 1");
$stmt->execute([$key]);
$lic = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$lic){
    deny("invalid");
}

if($lic['status']=="blocked"){
    deny("blocked");
}

/* First activation */
if(empty($lic['domain'])){
    $pdo->prepare("UPDATE licenses 
        SET domain=?, ip=?, fingerprint=?, last_check=NOW() 
        WHERE id=?")
        ->execute([$domain,$ip,$fp,$lic['id']]);

    allow();
}

/* Domain mismatch = crack */
if($lic['domain'] !== $domain){
    block($lic,$domain,$key);
}

/* Fingerprint mismatch = server moved */
if(!empty($lic['fingerprint']) && $lic['fingerprint'] !== $fp){
    block($lic,$domain,$key,true);
}

/* Update heartbeat */
$pdo->prepare("UPDATE licenses SET ip=?, last_check=NOW() WHERE id=?")
    ->execute([$ip,$lic['id']]);

allow();


/* ----------- FUNCTIONS ----------- */

function allow(){
    sign(["status"=>"active"]);
}

function deny($status){
    sign(["status"=>$status]);
    exit;
}

function block($lic,$domain,$key,$server=false){
    global $pdo;
    $pdo->prepare("UPDATE licenses SET status='blocked' WHERE id=?")->execute([$lic['id']]);

    $reason = $server ? "Server changed" : "Domain changed";

    tg("🚨 CourierBee Crack Detected\nKey: $key\nOriginal: {$lic['domain']}\nUsed on: $domain\nReason: $reason");

    sign(["status"=>"blocked"]);
    exit;
}

/* Signed JSON so hacker can't fake response */
function sign($data){
    $data['time']=time();
    $data['sig']=hash_hmac("sha256",$data['status'].$data['time'], "COURIERBEE_SECRET");
    echo json_encode($data);
}